<?php
/**
 * @link http://www.yiiframework.com/
 * @copyright Copyright (c) 2008 Yii Software LLC
 * @license http://www.yiiframework.com/license/
 */

namespace app\commands;

use yii\console\Controller;
use yii\console\ExitCode;
use Yii;
use app\models\RequestMaster;
use app\models\RequestServiceMaster;

/**
 * This command echoes the first argument that you have entered.
 *
 * This command is provided as an example for you to learn how to create console commands.
 *
 * @author Qiang Xue <qiang.xue@gmail.com>
 * @since 2.0
 */
class ScriptController extends Controller
{
    /**
     * This command echoes what you have entered as the message.
     * @param string $message the message to be echoed.
     * @return int Exit code
     */
    public function actionIndex($message = 'hello world')
    {
        echo $message . "\n";

        return ExitCode::OK;
    }

    public function actionTest()
    {
	$sendMail=0;
        $currentDate = date("Ymd");
        $newStatus = RequestMaster::NEW_STATUS;
        $decline = RequestMaster::DECLINED_STATUS;
	$revoked = RequestMaster::REVOKED_STATUS;
        $mysql = RequestServiceMaster::MYSQL;
        $command = new \yii\db\Query();
        $command->select(['RM.id AS ID', 'E.name AS Name', 'EI.access_username AS Username', 'RTM.name AS RequestName', 'RSM1.name AS RequestType', 'CM.name AS ClientName', 'RSM.name AS CurrentStatus', 'RM.number_of_days AS ExpireDays', 'date_format(RM.posting_time,"%Y-%m-%d") AS RequestDate', 'date_format((date_add(RM.posting_time, INTERVAL number_of_days day)),"%Y-%m-%d") AS ExpireDate', 'TIMESTAMPDIFF(DAY, now(), (date_add(RM.posting_time, INTERVAL number_of_days day))) AS ExpireDays', 'RL.file_path']);
        $command->from('RequestMaster RM');
        $command->innerJoin('RequestStatusMaster RSM', 'RSM.id=RM.status_id');
        $command->innerJoin('RequestTypeMaster RTM', 'RTM.id=RM.request_type_id');
        $command->innerJoin('RequestServiceMaster RSM1', 'RSM1.id=RM.request_service_id');
        $command->innerJoin('ClientMaster CM', 'CM.id=RM.client_id');
        $command->innerJoin('Employee E', 'E.id=RM.employee_id');
        $command->innerJoin('EmployeeInfo EI', 'EI.employee_id=E.id');
        $command->leftJoin('RequestLog RL', "RL.request_id=RM.id");
        $command->leftJoin('RequestStatusMaster RSM2', "RSM2.id=RL.status_id ");
        $command->where("number_of_days is not null AND RSM2.name='$newStatus' AND RSM.name NOT IN ('$decline','$revoked')");
        $row = $command->createCommand()->queryAll();

        $final = $file = '';
        $writeDirPath = \Yii::$app->basePath . "/files/revoke_$currentDate.txt";
        if (file_exists("$writeDirPath"))
        {
            unlink("$writeDirPath");
        }

        $mailBody = "The following request has been revoked by today $currentDate";
        foreach ($row as $data)
        {
            if (!empty($data['ExpireDays']) && $data['ExpireDays'] < 0)
            {
		$sendMail=1;
                $a = $data{'file_path'};
                $b = $data{'ClientName'};
                if (strcasecmp($mysql, $data{'RequestType'}) == 0)
                {
                    $file = "./automateMysqlPrivilegeScript.ksh $a qbrik_ij $b REVOKE" . PHP_EOL;
                    file_put_contents($writeDirPath, $file, FILE_APPEND);
                }
                $link = Yii::$app->urlManager->createAbsoluteUrl(['admin/request-detail', 'id' => $data{'ID'}]);
                if (empty($final))
                {
                    $body = "<p>$mailBody</p>" . "<a href='$link'>View Request Detail</a><br>";
                }
                else
                {
                    $body = "<a href='$link'>View Request Detail</a><br>";
                }
                $final .= $body;
            }
        }
	if ( $sendMail  == 1 )
{
        $mail = \Yii::$app->mailer->compose();
        $mail->setFrom('indrajith@qbrik.in');
        $mail->setTo('indrajith@qbrik.in');
        $mail->setCc(['security@qbrik.in', 'irudhayaraj@qbrik.in']);
        $mail->setSubject("Beeline - Request Revoke Summary List for $currentDate");
	if (file_exists("$writeDirPath"))
        {
            $mail->attach($writeDirPath);
	    $final .= "<br> Please find the attached script to revoke the mysql privilege.";
        }
	$mail->setHtmlBody($final);
        $mail->send();
}
    }

}
