<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Session;
use yii\data\ActiveDataProvider;
use yii\filters\VerbFilter;
use app\models\RoleMaster;
use app\models\LoginForm;
use app\models\Employee;
use Google\Auth\OAuth2;
use app\models\AccessMaster;
use idk\yii2\google\apiclient;
use Composer\Autoload;
use yii\web\User;
use app\components\AuthHandler;
use yii\authclient\BaseClient;
use yii\helpers\ArrayHelper;

class SiteController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];

    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'auth' => [
                'class' => 'yii\authclient\AuthAction',
                'successCallback' => [$this, 'onAuthSuccess'],
            ],
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    public function beforeAction($action)
    {
        $this->enableCsrfValidation = false;
        return parent::beforeAction($action);
    }

    public function onAuthSuccess($client)
    {
        (new AuthHandler($client))->handle();
    }

    public function actionIndex($flag = null)
    {
//        print_R($flag); exit;
        $session = Yii::$app->session;
        $model = new LoginForm();

        if($model->load(Yii::$app->request->post()))
        {
                $name = $_POST['LoginForm']['username'];
                $password = $_POST['LoginForm']['password'];
                if($model->authenticate ($name, $password))
                {
                    Yii::$app->user->login($model->getUser(), $model->rememberMe ? 3600 * 24 * 30 : 0);
                    $this->getAccess();
                    $this->menuField();
                    $empModel = Employee::findEmployee();

                    if($empModel->last_login === NULL && $flag == 0)
                    {
                        return $this->redirect(['request-master/change-password']);
                    }
                    else
                    {
                        $empModel->last_login = date("Y-m-d H:i:s");
                        $empModel->save(false);
                    }
                }
                else
                {
                    $session->setFlash('error','Username or Password is incorrect');
                }
        }
        elseif (isset($_GET['authclient']))
        {
            $userProfile = new OAuth2($config = []);
            $username = $userProfile->getUsername();
            if (!empty($username) && $model->login ())
            {
                $session->open();
//                $this->setRole($username);
                $this->menuField();
            }
            else
            {
                $session->setFlash('error','You are not allowed to access this website');
            }
        }
        return $this->render('login', [
                'model' => $model,
            ]);
    }

    public function menuField()
    {
         return $this->redirect(['request-master/index']);
    }

    public function actionLogout()
    {
        Yii::$app->session->close();
        Yii::$app->user->logout();
        return $this->goHome();
    }

    public function actionError()
    {
        return $this->render('error', []);
    }

    public function actionForgotPassword()
    {
        $flag = false;
        $model = new Employee();
        if(Yii::$app->request->post())
        {
            $name = $_POST['Employee']['name'];
            $code = $_POST['Employee']['employee_code'];
            $mailId = $_POST['Employee']['email'];
//            $name = preg_replace('/ /', '', $name);
            $valid  =  preg_match('/^[a-z_]+@qbrik\.in$/i', $mailId) && preg_match('/^Q00+[0-9]{2}$/i',$code) ? true : $model->addError('*','Code or Email is not in pattern');
            $query = Employee::find()->where(['employee_code' => $code, 'email' => $mailId])->one();
            $valid1 = !empty($query) ? true : $model->addError('*', 'Invalid user details');
            if(!empty($name) && !empty($code) && !empty($mailId) && $valid && $valid1)
            {
                $mailSubject = Employee::project_name .' - Change Password Requested by ' . $name;
                $details = 'Name : ' . $name . PHP_EOL .'Code : ' . $code  . PHP_EOL . 'Mail ID :' . $mailId;
                $mailTo = RoleMaster::admin_mail;
                $mail = \Yii::$app->mailer->compose();
                $mail->setFrom($mailId);
                $mail->setTo($mailTo);
                $mail->setSubject($mailSubject);
                $mail->setTextBody($details);
                $mail->send();
                Yii::$app->session->setFlash('success','Your Request has been sent successfully to the admin.');
                $flag = true;
                $this->redirect('index');
            }
        }

        if(!$flag)
        {
            return $this->render('_forgotPassword',['model' => $model]);
        }
    }

    public function getAccess()
    {
        $session = Yii::$app->session;
        $session->open();
        $role = \app\models\EmployeeRole::find()->where('employee_id=:employee_id',array(':employee_id'=>Yii::$app->user->identity->id))->all();
        foreach(ArrayHelper::map($role, 'id','role_id') as $id=>$role_id)
        {
            $access_ids = \app\models\RoleAccessMap::find()->where('role_id=:role_id',array(':role_id'=>$role_id))->all();
            foreach(ArrayHelper::map($access_ids, 'id','access_id') as $role_id=>$access_id)
            {
                $access[] = $access_id;
            }
        }
        foreach($access as $id=>$access_id)
        {
            $actions = ArrayHelper::map(AccessMaster::find()->where('id=:id',array(':id'=>$access_id))->all(),'id','name');
            foreach($actions as $id=>$actions)
            {
                $allowed_actions[] = $actions;
            }
        }
        $session['actions'] = $allowed_actions;
    }
}
