<?php

namespace app\models;

use Yii;
use yii\validators\RegularExpressionValidator;

/**
 * This is the model class for table "{{%ClientMaster}}".
 *
 * @property int $id
 * @property string $name
 * @property string $code
 * @property int $client_manager
 *
 * @property Employee $clientManager
 * @property RequestMaster[] $requestMasters
 */
class ClientMaster extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%ClientMaster}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'code', 'client_manager'], 'required'],
            [['client_manager'], 'integer'],
            [['name'], 'string', 'max' => 20],
            [['code'], 'string', 'max' => 10],
            ['name', RegularExpressionValidator::class,'pattern' => '/^[A-Za-z_\s]+$/', 'message' => 'Enter Valid name',],
            ['code', RegularExpressionValidator::class,'pattern' => '/^[A-Za-z0-9_\s]+$/', 'message' => 'Enter Valid code',],
            [['name', 'code'],'unique', 'targetAttribute' => ['name', 'code'], 'message' => 'This data already exists'],
            [['client_manager'], 'exist', 'skipOnError' => true, 'targetClass' => Employee::class, 'targetAttribute' => ['client_manager' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Client',
            'code' => 'Code',
            'client_manager' => 'Manager',
        ];
    }

    /**
     * Gets query for [[ClientManager]].
     *
     * @return \yii\db\ActiveQuery|EmployeeQuery
     */
    public function getClientManager()
    {
        return $this->hasOne(Employee::class, ['id' => 'client_manager']);
    }

    /**
     * Gets query for [[RequestMasters]].
     *
     * @return \yii\db\ActiveQuery|RequestMasterQuery
     */
    public function getRequestMasters()
    {
        return $this->hasMany(RequestMaster::class, ['client_id' => 'id']);
    }

    /**
     * {@inheritdoc}
     * @return ClientMasterQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new ClientMasterQuery(get_called_class());
    }
}
