<?php

namespace app\models;

use Yii;
use yii\validators\RegularExpressionValidator;

/**
 * This is the model class for table "{{%EmployeeInfo}}".
 *
 * @property int $id
 * @property int $employee_id
 * @property string|null $access_username
 * @property string $address
 * @property string $contact_number
 * @property string $emergency_contact_name
 * @property string $emergency_contact_number
 * @property string|null $effective_date
 * @property string|null $end_date
 *
 * @property Employee $employee
 */
class EmployeeInfo extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%EmployeeInfo}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        $validator = RegularExpressionValidator::class;
        return [
            [['employee_id', 'address', 'contact_number','access_username'], 'required'],
            [['employee_id'], 'integer'],
            [['effective_date', 'end_date'], 'safe'],
            [['access_username', 'contact_number', 'emergency_contact_number'], 'string', 'max' => 10],
            [['address'], 'string', 'max' => 200],
            [['emergency_contact_name'], 'string', 'max' => 30],
            ['access_username',$validator,'pattern' => '/^qbrik_+[a-z]{2}$/i','message' => 'Please enter a valid access username',],
            ['emergency_contact_name',$validator, 'pattern' => '/^[A-Za-z_\s]+$/', 'message' => 'Enter Valid Name',],
            ['contact_number',$validator, 'pattern' => '/^[0-9]{10}$/i', 'message' => 'Please enter a valid contact number',],
            ['emergency_contact_number',$validator, 'pattern' => '/^[0-9]{10}$/i', 'message' => 'Please enter a valid contact number',],
            ['emergency_contact_number','compare', 'compareAttribute' => 'contact_number','operator' => '!==','message' => 'Please enter new contact number',],
            [['employee_id'], 'exist', 'skipOnError' => true, 'targetClass' => Employee::class, 'targetAttribute' => ['employee_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'employee_id' => 'Employee ID',
            'access_username' => 'Access Username',
            'address' => 'Address',
            'contact_number' => 'Contact Number',
            'emergency_contact_name' => 'Emergency Contact Name',
            'emergency_contact_number' => 'Emergency Contact Number',
            'effective_date' => 'Joining Date',
            'end_date' => 'Relieve Date',
        ];
    }

    /**
     * Gets query for [[Employee]].
     *
     * @return \yii\db\ActiveQuery|EmployeeQuery
     */
    public function getEmployee()
    {
        return $this->hasOne(Employee::class, ['id' => 'employee_id']);
    }

    /**
     * {@inheritdoc}
     * @return EmployeeInfoQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new EmployeeInfoQuery(get_called_class());
    }
}
