<?php

namespace app\models;

use Yii;
use yii\base\Model;
use app\models\User;
use Google\Auth\OAuth2;
/**
 * LoginForm is the model behind the login form.
 *
 * @property-read User|null $user
 *
 */
class LoginForm extends Model
{
    public $username;
    public $password;
    public $rememberMe = true;

    private $_user = '';


    /**
     * @return array the validation rules.
     */
    public function rules()
    {
        return [
            // username and password are both required
            [['username', 'password',], 'required'],
            // rememberMe must be a boolean value
//            ['rememberMe', 'boolean'],
            // password is validated by validatePassword()
            ['password', 'validatePassword'],
        ];
    }

    /**
     * Validates the password.
     * This method serves as the inline validation for password.
     *
     * @param string $attribute the attribute currently being validated
     * @param array $params the additional name-value pairs given in the rule
     */
    public function validatePassword($attribute, $params)
    {
        if (!$this->hasErrors()) {
            $user = $this->getUser();

            if (!$user) {
                $this->addError($attribute, 'Incorrect username or password.');
            }
        }
    }

    
    public function login()
    { 
        if (isset($_GET['authclient'])) 
        {
            return Yii::$app->user->login($this->getUser(), $this->rememberMe ? 3600*24*30 : 0);
        }
        else 
        {
            return false; 
        }
    }

    public function getUser()
    {
        if(isset($_GET['authclient']))
        {
            $userProfile = new OAuth2($config = []);
            $username = $userProfile->getUsername();
            $this->_user = User::findByUsername($username);
        }
        elseif(empty($this->_user))
        {
            $this->_user = User::findByUsername($this->username);
        }
        
        return $this->_user;
    }

    public function authenticate($name, $password)
    { 
        $encPswd = User::encrypting($password);
        $user = User::findByUsername($name);
        if ($user['password'] == $encPswd)
        {
            return true;
        }
        else 
        {
            return false;
        }
    }
}
