<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "{{%RequestLog}}".
 *
 * @property int $id
 * @property int $request_id
 * @property string $message
 * @property string $posting_time
 * @property string $file_path
 *
 * @property RequestMaster $request
 */
class RequestLog extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    CONST SCENARIO_VPN = 'VPN';
    CONST Mysql_Privilege = 'mysql_privilege';
    CONST Upload_File = 'uploadFile';

    public static function tableName()
    {
        return '{{%RequestLog}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['posting_time'], 'required'],
            [['request_id', 'status_id', 'user_id'], 'integer'],
            [['posting_time'], 'safe'],
            [['message'], 'string', 'max' => 200],
            [['file_path'], 'string', 'max' => 100],/*[['message'],'required','on' => self::SCENARIO_VPN],*/
            [['request_id'], 'exist', 'skipOnError' => true, 'targetClass' => RequestMaster::class, 'targetAttribute' => ['request_id' => 'id']],
            [['status_id'], 'exist', 'skipOnError' => true, 'targetClass' => RequestStatusMaster::class, 'targetAttribute' => ['status_id' => 'id']],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => Employee::class, 'targetAttribute' => ['user_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'request_id' => 'Request ',
            'message' => 'Message(Reason For Decline)',
            'posting_time' => 'Posting Time',
            'file_path' => 'File Path',
            'status_id' => Yii::t('app', 'Status'),
            'user_id' => Yii::t('app', 'Request Handler'),
        ];
    }

    /**
     * Gets query for [[Request]].
     *
     * @return \yii\db\ActiveQuery|RequestMasterQuery
     */
    public function getRequest()
    {
        return $this->hasOne(RequestMaster::class, ['id' => 'request_id']);
    }

    public function getUser()
    {
        return $this->hasOne(Employee::class, ['id' => 'user_id']);
    }

    public function getStatus()
    {
        return $this->hasOne(RequestStatusMaster::class, ['id' => 'status_id']);
    }

    /**
     * {@inheritdoc}
     * @return RequestLogQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new RequestLogQuery(get_called_class());
    }

    public function getRequestLogDetail($id)
    {
        return self::find()->where('id = :id', array(':id' => $id))->one();
    }
}
