<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "RequestStatusMaster".
 *
 * @property int $id
 * @property string $name
 *
 * @property RequestLog[] $requestLogs
 * @property RequestMaster[] $requestMasters
 */
class RequestStatusMaster extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'RequestStatusMaster';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['name'], 'string', 'max' => 20],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'name' => Yii::t('app', 'Status'),
        ];
    }

    /**
     * Gets query for [[RequestLogs]].
     *
     * @return \yii\db\ActiveQuery|RequestLogQuery
     */
    public function getRequestLogs()
    {
        return $this->hasMany(RequestLog::class, ['status_id' => 'id']);
    }

    /**
     * Gets query for [[RequestMasters]].
     *
     * @return \yii\db\ActiveQuery|RequestMasterQuery
     */
    public function getRequestMasters()
    {
        return $this->hasMany(RequestMaster::class, ['status_id' => 'id']);
    }

    /**
     * {@inheritdoc}
     * @return RequestStatusMasterQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new RequestStatusMasterQuery(get_called_class());
    }
}