<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use app\models\RoleMaster;


$update = !empty($update) ? $update : false;

    if($update)
    {
        $selectedRoleIds = [];

        foreach ($employeeMap as $employeeRole) {
            $selectedRoleIds[] = $employeeRole->role_id;
        }
    }
    else
    {
            $employeeRole = $employeeMap;
            $selectedRoleIds = '';
    }


?>

<div class="employee-form">

    <?php $form = ActiveForm::begin(['enableClientValidation' => true, 'options' => ['style' => 'width:400px;'],]); ?>

    <?= $form->errorSummary([$model,$modelInfo,$employeeRole])  ?>
    
    <?=  $form->field($model, 'name')->textInput(['maxlength'=>30,'readonly' => $update]) ?>

    <?= $form->field($model, 'employee_code')->textInput(['maxlength'=>6,'placeholder'=>'Q0040','readonly' => $update]) ?> 
    
    <?= $form->field($employeeRole, 'role_id')->checkboxList(ArrayHelper::map(RoleMaster::find()->all(), 'id', 'name'),['value' => $selectedRoleIds]) ?>

    <?= $form->field($model, 'email')->textInput(['placeholder'=>'abc@qbrik.in','readonly' => $update]) ?>        
            
    <?= $form->field($modelInfo, 'access_username')->textInput(['placeholder'=>'qbrik_xx']) ?>    

    <?= $form->field($model, 'blood_group')->textInput(['maxlength'=>3,'readonly' => $update]) ?> 
    
    <?= $form->field($modelInfo, 'address')->textarea(['rows' => 3])?> 

    <?= $form->field($modelInfo, 'contact_number')->textInput(['maxlength'=>10,]) ?>
    
    <?= $form->field($modelInfo, 'emergency_contact_name')->textInput(['maxlength'=>30]) ?>
    
    <?= $form->field($modelInfo, 'emergency_contact_number')->textInput(['maxlength'=>10,]) ?> 
    
    <?= $form->field($modelInfo, 'effective_date')->widget(\yii\jui\DatePicker::className(),
               [
                'language' => 'en',
                'options' =>[
                    'class' =>  'form-control',
                     ],
                'clientOptions' =>
                [
                 'showAnim'=>'slideDown',   
                 'yearRange' => 'c-12:c+0',
                 'changeMonth'=> true,
                 'changeYear'=> true,
                    
            ],])    
    ?> 
    
    <?= $form->field($modelInfo, 'end_date')->widget(\yii\jui\DatePicker::className(),
            [
                'language' => 'en',
                'inline' => false,
                'options' =>[
                    'class' => 'form-control',
                ],
                'clientOptions' =>
                [
                 'showAnim'=>'fold',   
                 'yearRange' => 'c-12:c+0',
                 'changeMonth'=> true,
                 'changeYear'=> true,
                    
            ],])  ?>

    <div class="form-group">
        
        <?= Html::submitButton('Save', ['class' => 'btn btn-outline-primary btn-sm']) ?>
        
        <?= Html::a('Cancel',['/admin/employee-details'], ['class' => 'btn btn-outline-secondary btn-sm']) ?>
        
    </div>

    <?php ActiveForm::end(); ?>

</div>
