<?php

use app\models\Employee;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;
/** @var yii\web\View $this */
/** @var app\models\EmployeeSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Employees';
//$this->params['breadcrumbs'][] = $this->title;
?>
<style>
    .grid-view .pagination li a {
  margin: 0 5px;
}
</style>
<div class="employee-index">

    <h2>
        <?= Html::encode($this->title) ?> 
         <?php // if(RoleAccessMap::find()->where(['role_id'=>$role,'access_id'=> AccessMaster::CREATE_EMPLOYEE])->one()) { ?>
         <?= Html::a('Create Employee',['admin/create'], ['class' => 'btn btn-outline-success btn-sm','style' => 'float:right;']) ?>
         <?php // } ?>
    </h2>

    <?=
        GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'headerRowOptions' => [
         ],
        'columns' => [
            [
                'header' => 'Name',
                'attribute' => 'name',
            ],
            [
                'header' => 'Code',
                'attribute' => 'employee_code',
            ],
        [
            'header' => 'Role',
                'value' => function ($model) {
                   $items = $model->employeeRole;
                  
                    foreach ($items as $item) {
                         $roles[] = $item->role->name;
                    }
                    return  implode(",\n",$roles);
                },
            ],
            [
            'header' => 'Status',
            'attribute' => 'is_active',
            'value' => function ($model) {
                if ($model->is_active == 1)
                {
                    return 'Active';
                }
                else
                {
                    return 'Inactive';
                }
            },
        ],
        [
                'class' => ActionColumn::className(),
                'header' => '<a style="color: #212529;">Action</a>',
                'template' => '{view}',
                'buttons' => 
                [
                    'view' => function ($url, $model, $key) 
                    {
                        return  Html::a('View',['admin/view','id' => $model->id]);
                    }
                ],
                'urlCreator' => function ($action, Employee $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],
        ],
    ]); ?>

     
</div>
