<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use app\models\RoleAccessMap;
use app\models\AccessMaster;

/** @var yii\web\View $this */
/** @var app\models\Employee $model */

$this->title = "Employee Detail";

\yii\web\YiiAsset::register($this);
?>
<div class="employee-view">

    <h2>
        <?= Html::encode($this->title) ?>
        <?= Html::a('Back',['admin/employee-details'], ['class' => 'btn btn-outline-dark btn-sm','style' => 'float:right;']) ?>
    </h2>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
//            'id',
            'name',
            [
                'label' => 'Username',
                'value' => function ($model) {
                    $items = $model->employeeInfos;
                    foreach ($items as $item) {
                        $html =  $item->access_username ;
                    }
                    return $html;
                },
                'format' => 'html',
            ],
            'employee_code',
            [
                'label' => 'Roles',
                'value' => function ($model) {
                   $items = $model->employeeRole;
                  
                    foreach ($items as $item) {
                         $roles[] = $item->role->name;
                    }
                    return  implode(",\n",$roles);
                },
            ],    
            'email',
//            'blood_group',
            'created_at',
           /* [
                'label' => 'Address',
                'value' => function ($model) {
                    $items = $model->employeeInfos;
                    foreach ($items as $item) {
                        $html =  $item->address ;
                    }
                    return $html;
                },
                'format' => 'html',
            ],
            [
                'label' => 'Contact Number',
                'value' => function ($model) {
                    $items = $model->employeeInfos;
                    foreach ($items as $item) {
                        $html =  $item->contact_number ;
                    }
                    return $html;
                },
                'format' => 'html',
            ],
            [
                'label' => 'Emergency Name',
                'value' => function ($model) {
                    $items = $model->employeeInfos;
                    foreach ($items as $item) {
                        $html =  $item->emergency_contact_name ;
                    }
                    return $html;
                },
                'format' => 'html',
            ],
            [
                'label' => 'Emergency Number',
                'value' => function ($model) {
                    $items = $model->employeeInfos;
                    foreach ($items as $item) {
                        $html =  $item->emergency_contact_number ;
                    }
                    return $html;
                },
                'format' => 'html',
            ],*/
    ],
            'template' => '<tr><th style="width:20%;">{label}</th><td style="width:80%;">{value}</td></tr>', 
    ]) ?>
    <p style="float: right">
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-outline-primary btn-sm']) ?>
        <span></span>
        <?php if (in_array(AccessMaster::DELETE_EMPLOYEE, Yii::$app->session->get('actions')) && $model->is_active === 1)
        { ?>
            <?=
            Html::a('Terminate', ['delete', 'id' => $model->id], [
                'class' => ' btn btn-outline-danger btn-sm',
                'data' => [
                    'confirm' => 'Are you sure you want to delete this item?',
                    'method' => 'post',
                ],
            ]) ?>
        <?php } ?>
        <span></span> 
        <?php if(in_array(AccessMaster::RESET_PASSWORD,Yii::$app->session->get('actions')))
        { ?>
            <?= Html::a('Reset Password', ['admin/reset-password','id' => $model->id] ,['class' => 'btn btn-outline-success btn-sm']) ?>
        <?php } ?>
    </p>
    
</div>
