<?php

use app\models\RequestMaster;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;
use app\models\Employee;
use app\models\ClientMaster;
use app\models\RequestServiceMaster;
use app\models\RequestStatusMaster;

/** @var yii\web\View $this */
/** @var app\models\RequestMasterSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = Yii::t('app', 'Request');

?>

<style>
    .qb_table img{width: 30px;height: 25px;margin: 5px;}
    .grid-view .pagination li a {
  margin: 0 5px;
}
</style>

<div class="request-master-index">

    <h2>
          <?= Html::encode($this->title) ?>
    </h2>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'pager' =>[
          ],
        'tableOptions' => ['class' => 'table table-striped table-bordered qb_table'],
        'columns' => [
            [
              'header' => 'Request #',
              'attribute' => 'id',
            ],
            [
                'header' => 'Name',
                'attribute' => 'employee_id',
                'value'=> 'employee.name',
                'filter' => ArrayHelper::map(Employee::find()->all(), 'id', 'name'),
            ],
            [
                    'header' => 'Username',
                    'value'=> function($model)
                    {
                            return $model->employee->employeeInfos[0]->access_username;
                    },

                ],
            [
                'header' => 'Access ',
                'attribute'=> 'request_service_id',
                'value' => 'requestService.name',
                'filter' => ArrayHelper::map(RequestServiceMaster::find()->all(), 'id', 'name'),
            ],
            [
                'header' => 'Instance',
                'attribute' => 'client_id',
                'filter' => ArrayHelper::map(ClientMaster::find()->all(), 'id', 'name'),
                'value'=> function($model)
                {
                    return empty($model->client_id) ? 'Qbrik' : $model->client->name ;
                },
            ],
             [
                    'header' => 'Status',
                    'attribute' => 'status_id',
                    'value' => 'status.name',
                    'filter' => ArrayHelper::map(RequestStatusMaster::find()->all(), 'id', 'name'),


            ],
            [
                'header' => 'Posting Time',
                'value'=> function($model)
                {
                $current_year = date("Y");
                $value = strtotime($model->posting_time);
//                $data = $current_year == date('Y', $value) ? date('d M, g:i a', $value) : date('M,d,Y g:i a', $value);
                $data = date('d/m/Y H:i:s', $value);
                return $data;
            }

            ],

        [
                'class' => ActionColumn::className(),
                'header' => '<a style="color: #212529;">Action</a>',
                'template' =>  '{view}{approve}{decline}',

                'buttons' =>
                [
                    'view' => function ($url, $model, $key)
                    {
                        return  Html::a( 'View', ['admin/request-detail','id' => $model->id]
                                    );
                    }
                ],

                'urlCreator' => function ($action, RequestMaster $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],

        ],

    ]); ?>


</div>
