<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use app\models\AccessMaster;

$this->title = 'Tables';
?>

<style>
    .grid-view .pagination li a {
  margin: 0 5px;
}
</style>

<div class="employee-index">
    <h2>
        <?= Html::encode($this->title) ?>
        <?php if(in_array(AccessMaster::CREATE_TABLE,Yii::$app->session->get('actions'))) { ?>
       <?= Html::a('Create Table',['admin/table-create'], ['class' => 'btn btn-outline-success btn-sm','style' => 'float:right;']) ?>
       <?php } ?>

    </h2>

    <?=
        GridView::widget([
        'dataProvider' => $dataProvider,
        'layout' => '{summary}{items}{pager}',
        'options' => ['class' => 'grid-view','style' => 'width:30%;'],
//        'filterModel' => $searchModel,
        'columns' => [

            [
                'class' => ActionColumn::className(),
                'header' => '<a style="color: #212529;">Action</a>',
                'template' => '{update}',
                'buttons' =>
                [
                    'update' => function ($url, $model, $key)
                    {
                        return  Html::a($model->name,['admin/table-update','id' => $model->id]);
                    }
                ],
                'urlCreator' => function ($action, \app\models\TableMaster $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
//                'urlCreator' => function ($action,$model) {
//                        $action = 'admin/table-update';
//                        $url = Url::toRoute([$action, 'id' => $model->id]);
//                        return $url;
//                }
            ],
        ],

    ]); ?>


</div>
