<?php
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\web\View;
use yii\widgets\ActiveForm;
$script = 'App.init();';
$script = <<< JS
    $(document).ready(function ()
    {        
        $('#user-employee_id').change(function ()
        {
            loadReasons();
        });
    });

   
JS;
$this->registerJs($script, View::POS_READY);

/* @var $this yii\web\View */
/* @var $user app\models\User */
/* @var $form yii\widgets\ActiveForm */
?>
<script type="text/javascript">
function loadReasons()
{
var employeeId = $('#user-employee_id').val();
$.ajax({
   url: "<?php echo Yii::$app->getUrlManager()->createUrl('/user/user/useremail')?>",
   type: 'post',
   data: {
             id: employeeId ,
         },
   success: function (data) {
  $( "#user-email" ).val( data );
   }
});
}

</script>

<div class="user-form" style="align: center;">
    <?php $form = ActiveForm::begin(); ?>
    <div class="row">
<div class="col-xs-12 col-md-4">
    <?= $form->field($user, 'employee_id')->dropDownList(ArrayHelper::map(\app\models\Employee::find()->where(['date_of_leaving'=>null])->all(), 'id', 'employee_no'),['prompt'=>'select Employee',])->label('Employee') ?>
    </div>
</div>
<div class="row">
<div class="col-xs-12 col-md-4">
    <?= $form->field($user, 'username')->textInput(['maxlength' => true]) ?>
    </div>
</div>
<div class="row">
<div class="col-xs-12 col-md-4">
    <?= $form->field($user, 'email')->textInput(['maxlength' => true,'readonly'=> true]) ?>
    </div>
</div>
<div class="row">
<div class="col-xs-12 col-md-4">
    <?= $form->field($user, 'password')->passwordInput(['maxlength' => true]) ?>
    </div>
</div>
<div class="row">
<div class="col-xs-12 col-md-4">
    <?= $form->field($user, 'ReEnterPassword')->passwordInput(['maxlength' => true]) ?>
    </div>
</div>
<div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
