<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap4\Breadcrumbs;
use yii\bootstrap4\Html;
use yii\bootstrap4\Nav;
use yii\bootstrap4\NavBar;
use app\models\Employee;
use app\models\RoleMaster;

AppAsset::register($this);

?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">
<head>
    <meta charset="<?= Yii::$app->charset ?>" >
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <?php $this->registerCsrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body class="d-flex flex-column h-100" style="padding: 1px;">
<?php $this->beginBody() ?>

<header>
    <?php //style="color: #791cdf;"

    if(!Yii::$app->user->isGuest && Yii::$app->user->identity->last_login != null)
    {$url =  ['/request-master/index'];}
    else {$url = ['/site/index']; }

    NavBar::begin([
        'brandLabel' => Yii::$app->name,
        'brandUrl' => $url ,                    ////Yii::$app->homeUrl,
        'options' => [
            'class' => 'navbar navbar-expand-md navbar-dark fixed-top',
            'style' => (!Yii::$app->user->isGuest) ? 'background-color: #791cdf' :'background-color: White' ,
        ],
    ]);

            if(!Yii::$app->user->isGuest && Yii::$app->user->identity->last_login != null)
            {
                $menuItems   = [['label' => 'Admin', 'url' => ['/admin/index']],];
                $menuItems[] = ['label' => 'Table', 'url' => ['/admin/table-view'],];
//              $menuItems[] = ['label' => 'Forms', 'url' => ['/admin/list-of-forms'],];
                $menuItems[] = ['label' => 'Client', 'url' => ['/admin/client-view'],];
                $menuItems[] = ['label' => 'Employee', 'url' => ['/admin/employee-details']];
                $menuItems[] = ['label' => 'Info', 'url' => ['/admin/master'],];
    $menuItems[] = ['label' => 'Logout('. Yii::$app->user->identity->name .')', 'url' => ['/site/logout'],'options' =>'' /*['style' => 'padding-left: 57.5rem;']*/,'linkOptions' => ['data-method' => 'post']];

            }
            else
            {
                 $menuItems[] = ['label' => ' ', 'url' => $url];
}

    echo Nav::widget([
        'options' => ['class' => 'navbar-nav '],
        'items' => $menuItems,

    ]);
    NavBar::end();
    ?>
</header>

<main role="main" class="flex-shrink-0" >
    <div class="container" >
        <?= Breadcrumbs::widget([
            'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
        ]) ?>
        <?= Alert::widget() ?>
        <?= $content ?>
    </div>
</main>

<!--<footer class="footer mt-auto py-3 text-muted">
    <div class="container">
    </div>
</footer>-->

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
