<?php


use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;
use app\models\RequestStatusMaster;

/** @var yii\web\View $this */
/** @var app\models\RequestMasterSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = Yii::t('app', 'Access Requested');
//$this->params['breadcrumbs'][] = $this->title;
?>
<style>
    .grid-view .pagination li a {
  margin: 0 5px;
}
</style>

    <h2>
        <?= Html::encode($this->title) ?>
        <?= Html::a('New Request',['request-master/request',], ['class' => 'btn btn-outline-success btn-sm','style' => 'float:right;']) ?>
          <!-- <?= Html::a(Html::img('@web/images/download.png',['style'=>'width:50px;height:50px;float:right;']), ['request-master/request']) ?> -->
    </h2>
    <?php $color = ['style' => 'color: #007bff;']; // echo $this->render('_search', ['model' => $searchModel]);
    ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
//        'filterModel' => $searchModel,
//        /* 'layout' => '{items}\n{pager}', */
        'columns' =>
        [
            [
              'header' => 'Request #',
              'attribute' => 'id',
            ],
            [
                'attribute' => 'Name',
                'value'=> 'employee.name',
//                'filter' => ArrayHelper::map(Employee::find()->all(), 'id', 'name'),

            ],
            [
                'header' => 'Service',
                'attribute'=> 'requestService.name'

            ],
            [
                'header' => 'Client',
                'value'=> function($model)
                {
                    return empty($model->client_id) ? '--' : $model->client->name ;
                }

            ],
            [
                'header' => 'Instance',
                'value'=> function($model)
                {
                    return empty($model->instance_id) ? '--' : $model->instance->name;
                }

            ],

            [
                'header' => 'Posting Time',
                'value'=> function($model)
                {
                    $value = strtotime($model->posting_time);
                    $current_year = date("Y");
                    //                $data = $current_year == date('Y', $value) ? date('d M, g:i a', $value) : date('M,d,Y g:i a', $value);
                $data = date('d/m/Y H:i:s', $value);
                    return $data;
                }

            ],
            [
                    'header' => 'Access Needed Until',
                    'value'=> function($model)
                    {
                      if(!empty($model->number_of_days))
                      {
                            $current_year = date("Y");
                            $value = strtotime($model->posting_time);
                            $date = date('d-m-Y', $value);
                            $date = date_create($date);
                            $days = $model->number_of_days - 1;
                            $enddate = date_add($date, date_interval_create_from_date_string(" $days days"));
    //                        $date = date_format($enddate,"Y") == $current_year ? date_format($enddate,"d M") : date_format($enddate,"M d,Y");
                            $date = date_format($enddate,'d/m/Y');
                            return $date;
                      }
                      else
                      {
                           return 'Forever';
                      }
                    }
            ],
            [
                    'header' => 'Status',
                    'attribute' => 'status_id',
                    'value' => 'status.name',
            ],

              [
                'class' => ActionColumn::className(),
                'header' => '<a style="color: #212529;">Action</a>',
                'template' =>  '{view}',
                'buttons' =>
                [
                    'view' => function ($url, $model, $key)
                    {
                        return  Html::a('View',['request-master/view','id' => $model->id]);
                    }
                ],

                        'urlCreator' => function ($action, $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],

        ],
   ]); ?>



